@extends('layout.app')

@section('content')

    <section class="py-10 d-flex items-center bg-light-2" style="margin-top: 6rem;">
        <div class="container">
          <div class="row y-gap-10 items-center justify-between">
            <div class="col-auto">
              <div class="row x-gap-10 y-gap-5 items-center text-14 text-light-1">
                <div class="col-auto">
                  <div class=""><a href="{{route('home')}}">Home</a></div>
                </div>
                <div class="col-auto">
                  <div class="">></div>
                </div>
                <div class="col-auto">
                  <div class=""><a href="{{route('all-tours')}}">Tours</a></div>
                </div>
                <div class="col-auto">
                  <div class="">></div>
                </div>
                <div class="col-auto">
                  <div class="text-dark-1">4 Countries With Tomatina</div>
                </div>
              </div>
            </div>

            <div class="col-auto">
              <a href="{{route('all-tours')}}" class="text-14 text-dark-1 underline">All Tours</a>
            </div>
          </div>
        </div>
    </section>

    <section class="pt-40">
        <div class="container">
            <div class="row y-gap-15 justify-between items-end">
                <div class="col-auto">
                    <h1 class="text-30 fw-600">4 Countries With Tomatina</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="pt-40 js-pin-container mb-50">
        <div class="container">
          <div class="row y-gap-30">
            <div class="col-lg-7">
              <div class="relative d-flex justify-center overflow-hidden js-section-slider" data-slider-cols="base-1" data-nav-prev="js-img-prev" data-nav-next="js-img-next">
                <div class="swiper-wrapper">
                  <div class="swiper-slide">
                    <img src="{{asset('assets/img/tours/tomatina/1.jpg')}}" alt="image" class="rounded-4 col-12 h-full object-cover">
                  </div>

                  <div class="swiper-slide">
                    <img src="{{asset('assets/img/tours/tomatina/2.jpg')}}" alt="image" class="rounded-4 col-12 h-full object-cover">
                  </div>

                  <div class="swiper-slide">
                    <img src="{{asset('assets/img/tours/tomatina/3.jpg')}}" alt="image" class="rounded-4 col-12 h-full object-cover">
                  </div>

                  <div class="swiper-slide">
                    <img src="{{asset('assets/img/tours/tomatina/1.jpg')}}" alt="image" class="rounded-4 col-12 h-full object-cover">
                  </div>

                </div>

                <div class="absolute h-full col-11">

                  <button class="section-slider-nav -prev flex-center button -blue-1 bg-white shadow-1 size-40 rounded-full sm:d-none js-img-prev">
                    <i class="icon icon-chevron-left text-12"></i>
                  </button>

                  <button class="section-slider-nav -next flex-center button -blue-1 bg-white shadow-1 size-40 rounded-full sm:d-none js-img-next">
                    <i class="icon icon-chevron-right text-12"></i>
                  </button>

                </div>

                <div class="absolute h-full col-12 z-2 px-20 py-20 d-flex justify-end items-end">
                  <a href="{{asset('assets/img/tours/tomatina/1.jpg')}}" class="button -blue-1 px-24 py-15 bg-white text-dark-1 js-gallery" data-gallery="gallery2">
                    See Photos
                  </a>
                  <a href="{{asset('assets/img/tours/tomatina/2.jpg')}}" class="js-gallery" data-gallery="gallery2"></a>
                  <a href="{{asset('assets/img/tours/tomatina/1.jpg')}}" class="js-gallery" data-gallery="gallery2"></a>
                  <a href="{{asset('assets/img/tours/tomatina/3.jpg')}}" class="js-gallery" data-gallery="gallery2"></a>
                  <a href="{{asset('assets/img/tours/tomatina/2.jpg')}}" class="js-gallery" data-gallery="gallery2"></a>
                </div>
              </div>

              <h3 class="text-22 fw-500 mt-30">
                Key Points
              </h3>

              <div class="row y-gap-30 justify-between pt-20">

                <div class="col-md-auto col-6">
                  <div class="d-flex">
                    <i class="icon-clock text-22 text-blue-1 mr-10"></i>
                    <div class="text-15 lh-15">
                      Duration:<br> 12 Days
                    </div>
                  </div>
                </div>

                <div class="col-md-auto col-6">
                  <div class="d-flex">
                    <i class="icon-customer text-22 text-blue-1 mr-10"></i>
                    <div class="text-15 lh-15">
                        Spain Only:<br> PKR 875,000 Per Person
                    </div>
                  </div>
                </div>

                <div class="col-md-auto col-6">
                  <div class="d-flex">
                    <i class="icon-route text-22 text-blue-1 mr-10"></i>
                    <div class="text-15 lh-15">
                        Price for 4 Countries Europe Tour:<br> PKR 1,375,000 Per Person
                    </div>
                  </div>
                </div>

                <div class="col-md-auto col-6">
                    <div class="d-flex">
                      <i class="icon-route text-22 text-blue-1 mr-10"></i>
                      <div class="text-15 lh-15">
                          4 Countries name:<br> Spain - Paris - Amsterdam - Italy
                      </div>
                    </div>
                  </div>

              </div>

              <div class="border-top-light mt-40 mb-40"></div>

              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Important Note:</h3>
                    <div class="text-15">
                        Hotel Rooms, Traveling Route, Traveling dates and Air tickets, Airline, departure and arrival
                        points are subject To Availability. Best possible option will be chosed.
                    </div>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Note</h3>
                    <div class="text-15">
                        Visas Approval is Subjected to Immigration. Litso is not responsible in case of
                        Visa is rejected / delayed, visa fee is non refundable in any case. Further terms and condition sare
                        mentioned on the invoice. Allterms & conditions are applied*.
                    </div>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Special Note:</h3>
                    <div class="text-15">
                        International Air Ticket Fare 350,000 PKR per Person include in this package price, at
                        the time of ticket booking if ticket fare increase then increasing amount to be paid by the passenger.
                    </div>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Package Details:</h3>
                    <div class="text-15">
                        Price for Spain Only - PKR 875,000 Per Person
                    </div>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Itinerary:</h3>
                  <ul class="list-disc text-15 mt-10">
                    <li>25 AUG: Arrival Barcelona</li>
                    <li>26 AUG: Explore Barcelona</li>
                    <li>27 AUG: Go to Valencia and visit</li>
                    <li>28 AUG: Celebrate la Tomatina at Bunol</li>
                    <li>29 AUG: Go to Madrid</li>
                    <li>30 AUG: Visit Madrid</li>
                    <li>31 AUG: Visit Toledo</li>
                    <li>01 SEP: Departure</li>
                  </ul>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Package Details:</h3>
                    <div class="text-15">
                        Price for 4 Countries Europe Tour - PKR 1,375,000 Per Person
                    </div>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Itinerary:</h3>
                  <ul class="list-disc text-15 mt-10">
                    <li>25 AUG: Arrival Barcelona</li>
                    <li>26 AUG: Explore Barcelona</li>
                    <li>27 AUG: Go to Valencia and visit</li>
                    <li>28 AUG: Celebrate la Tomatina at Bunol</li>
                    <li>29 AUG: Go to Madrid</li>
                    <li>30 AUG: Visit Madrid, Move to Paris</li>
                    <li>31 AUG: Paris Exploration, Move to Amsterdam</li>
                    <li>01 SEP: Experience Amsterdam</li>
                    <li>02 SEP: Move to Florence and Explore</li>
                    <li>03 SEP: Visa Pisa, Move to Rome</li>
                    <li>04 SEP: Explore Rome & Vatican City</li>
                    <li>05 SEP: Departure</li>
                  </ul>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Hotels:</h3>
                    <div class="text-15">
                        3* to 4* Hotels / Twin or Triple Sharing
                    </div>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Package Inclusions:</h3>
                  <ul class="list-disc text-15 mt-10">
                    <li>Accommodation on Twin/Triple Sharing</li>
                    <li>2023 Tomatina Festival Access to Bunol from Valencia</li>
                    <li>Tours as per mentioned in the itinerary</li>
                    <li>Use of A/C Vehicle for Airport Transfers & Tours</li>
                    <li>City Tax Per Night at hotels</li>
                    <li>Intercity Flights/Trains/Buses</li>
                    <li>International Airfare</li>
                    <li>Visa Fee, Appointment, Insurance & Assistance Included</li>
                  </ul>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500">Price excludes:</h3>
                  <ul class="list-disc text-15 mt-10">
                    <li>All personal incidental expenses</li>
                    <li>Any item not included in the itinerary</li>
                    <li>Meals & drinks not mentioned</li>
                    <li>Gratuities/Tipping to tour guide & driver</li>
                    <li>Unscheduled flight/train transfers</li>
                  </ul>
                </div>
              </div>
              <div class="row x-gap-40 y-gap-40">
                <div class="col-12">
                  <h3 class="text-22 fw-500" style="color:red;">Note:</h3>
                  <div class="text-15" style="color:red;">
                    *Last Date to confirm is 05 June 2024. Passport & PKR 250,000 Advance Required for confirmation. <br>
                    *All rates are subject to availability and can change as per the date of confirmation. <br>
                    *Standard Check in and Check out time is 14:00 and 12:00 respectively. <br>
                    *Rate of Exchange would be as per the date of payment as per International Transaction Card Rates
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-5">
                <div class="js-pin-content">
                    <div class="row">
                        <div class="col-lg-12">
                            <img src="{{asset('assets/img/tours/tomatina/tomatina-tour.jpg')}}" alt="">
                            <h3 class="text-22 fw-500">4 Countries With Tomatina Tour  Registration Form</h3>
                        </div>
                    </div>
                    <form action="{{ route('submit-tour') }}" method="get">
                        @csrf
                        <div class="row">
                            <div class="col-lg-6 mt-30">
                                <label for="name">Name</label>
                                <input style="border: 1px solid #f5f5f5; padding-left:10px;" type="text" name="name" id="name" placeholder="Enter Name" value="{{ old('name') }}" required>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="email">Email</label>
                                <input style="border: 1px solid #f5f5f5; padding-left:10px;" type="email" name="email" id="email" placeholder="Enter Email" value="{{ old('email') }}" required>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="phone">Phone No.</label>
                                <input style="border: 1px solid #f5f5f5; padding-left:10px;" type="text" name="phone" id="phone" placeholder="Enter Phone No." value="{{ old('phone') }}" required>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="no_of_traveler">No. of Travelers</label>
                                <input style="border: 1px solid #f5f5f5; padding-left:10px;" type="text" name="no_of_traveler" id="no_of_traveler" placeholder="Enter No. of Travelers" value="{{ old('no_of_traveler') }}" required>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="selected_tour">Where would you like to Travel?</label>
                                <select style="border: 1px solid #f5f5f5; padding-left:10px;" name="selected_tour" id="selected_tour" required>
                                    <option value="" disabled>Select Tour</option>
                                    <option value="thailand"> Thailand Tour </option>
                                    <option value="baku_and_istanbul" selected> Baku & Istanbul Combo Tour </option>
                                    <option value="srilanka">Best of Srilanka Tour</option>
                                    <option value="tomatina">4 Countries With Tomatina</option>
                                </select>
                            </div>
                            <div class="col-lg-6 mt-30">
                                <label for="depart_date">Departure Date</label>
                                <input type="date" name="depart_date" id="depart" required value="{{ old('depart_date') }}"  required>
                            </div>
                            <div class="col-lg-12 mt-30">
                                <label for="message">Message</label>
                                <textarea style="border: 1px solid #f5f5f5; padding-left:10px;" name="message" id="message" cols="30" rows="3" placeholder="Write your message">{{ old('message') }}</textarea>
                            </div>
                            <div class="col-lg-12">
                                <div class="button-item">
                                    <button type="submit" class="mainSearch__submit button -yellow-new py-15 px-35 col-12 rounded-4 bg-dark-new text-white">
                                        Submit
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
          </div>
        </div>
    </section>

@endsection
@section('customJs')

@endsection
