<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SearchQuery extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'search_queries';

    /**
     * The primary key associated with the table.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'flying_from',
        'flying_to',
        'depart_date',
        'return_date',
        'direct_flight_only',
        'adults',
        'childeren',
        'infants',
        'flight_type',
        'name',
        'email',
        'phone',
        'subject',
        'message',
    ];
}
