<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AirportDetail;
use App\Models\SearchQuery;
use App\Models\TourModel;
use Illuminate\Support\Facades\Redirect;

class SiteController extends Controller
{
    public function homaPage(){
        $allAirports = AirportDetail::all();
        return view('index', compact('allAirports'));
    }
    public function allTours(){
        return view('alltours');
    }
    public function thailandTour(){
        return view('tours.thailandtour');
    }
    public function bakuAndIstanbulTour(){
        return view('tours.bakuistanbul');
    }
    public function srilankaTour(){
        return view('tours.srilanka');
    }
    public function countriesWithTomatinaTour(){
        return view('tours.tomatina');
    }
    public function submitSearch(Request $request)
    {
        // Validate the request data
        $validated = $request->validate([
            'from' => 'required|string|max:255',
            'to' => 'required|string|max:255',
            'depart_date' => 'required|date',
            'return_date' => 'nullable|date',
            'direct-flight-only' => 'sometimes|in:on', // Update the field name here
            'js-count-adult' => 'required|integer',
            'js-count-child' => 'required|integer',
            'js-count-infants' => 'required|integer',
            'flight-type' => 'required|string|max:255',
        ]);

        // Store the validated data in the database
        $searchQuery = new SearchQuery();
        $searchQuery->flying_from = $validated['from'];
        $searchQuery->flying_to = $validated['to'];
        $searchQuery->depart_date = $validated['depart_date'];
        $searchQuery->return_date = $validated['return_date'] ?? null;
        $searchQuery->direct_flight_only = isset($validated['direct-flight-only']) ? 'yes' : 'no'; // Update the field name here
        $searchQuery->adult_count = $validated['js-count-adult'];
        $searchQuery->child_count = $validated['js-count-child'];
        $searchQuery->infant_count = $validated['js-count-infants'];
        $searchQuery->flight_type = $validated['flight-type'];
        $searchQuery->save();

        // Return a response (e.g., redirect or JSON response)
        return Redirect::route('query-contact', ['id' => $searchQuery->id]);
    }
    public function submitTour(Request $request)
    {
        // Validate the request data
        // $validatedData = $request->validate([
        //     'name' => 'required|string|max:255',
        //     'email' => 'required|email|max:255',
        //     'phone' => 'required|string|max:20',
        //     'no_of_traveler' => 'required|integer|min:1',
        //     'selected_tour' => 'required|string',
        //     'depart_date' => 'required|date',
        //     'message' => 'nullable|string|max:1000',
        // ]);

        // Store the validated data in the database
        $tourQuery = new TourModel();
        $tourQuery->name = $request['name'];
        $tourQuery->email = $request['email'];
        $tourQuery->phone = $request['phone'];
        $tourQuery->no_of_traveler = $request['no_of_traveler'];
        $tourQuery->selected_tour = $request['selected_tour'];
        $tourQuery->depart_date = $request['depart_date'];
        $tourQuery->message = $request['message'];
        $tourQuery->save();
        return Redirect::route('thank-you');
    }
    public function queryContact($id)
    {
        return view('querycontact', ['id' => $id]);
    }
    public function submitQueryContact(Request $request)
    {
        // dd($request->id);
        // Check if the ID exists in the SearchQuery table
        $searchQuery = SearchQuery::find($request->id);

        if (!$searchQuery) {
            // If the ID does not exist, return an error response or redirect
            return redirect()->route('home')->with('error', 'Search query not found.');
        }else{
            // Validate the request data
            $validated = $request->validate([
                'name' => 'required|string|max:255',
                'email' => 'required|email|max:255',
                'phone' => 'required|string|max:20',
                'subject' => 'required|string|max:255',
                'message' => 'required|string',
            ]);

            $searchQuery->update([
                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'subject' => $request->subject,
                'message' => $request->message,
            ]);

            // Return a response (e.g., redirect to home)
            return Redirect::route('thank-you');
        }
    }
    public function thankYou(){
        return view('thankyou');
    }
    public function visaChecklist(){
        return view('visachecklist');
    }
    public function contact(){
        return view('contact');
    }
}
